/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.jfronny.libjf.config.impl.ui.tiny.entry;

import io.gitlab.jfronny.commons.ref.R;
import io.gitlab.jfronny.libjf.LibJf;
import io.gitlab.jfronny.libjf.config.api.v2.EntryInfo;
import io.gitlab.jfronny.libjf.config.api.v2.Naming;
import io.gitlab.jfronny.libjf.config.impl.ui.tiny.entry.WidgetFactory;
import java.util.List;
import java.util.Objects;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2561;
import org.jetbrains.annotations.Nullable;

@Environment(value=EnvType.CLIENT)
public class WidgetState<T> {
    public EntryInfo<T> entry;
    public List<WidgetState<?>> knownStates;
    public Naming.Entry naming;
    public class_2561 error;
    public boolean inLimits = true;
    public String tempValue;
    public boolean managedTemp = true;
    public T cachedValue;
    @Nullable
    public WidgetFactory factory;
    private Runnable onUpdateCache = R::nop;

    public void initialize(EntryInfo<T> entry, List<WidgetState<?>> knownStates, @Nullable WidgetFactory factory, Naming.Entry naming) {
        this.entry = entry;
        this.knownStates = knownStates;
        this.factory = factory;
        this.naming = naming;
        this.updateCache();
    }

    public void updateCache() {
        try {
            this.updateCache(this.entry.getValue());
        }
        catch (IllegalAccessException e) {
            LibJf.LOGGER.error("Could not set widget state cache to current value", (Throwable)e);
        }
    }

    public void updateCache(T newValue) {
        T previous = this.cachedValue;
        this.cachedValue = newValue;
        if (this.managedTemp) {
            String string = this.tempValue = newValue == null ? null : newValue.toString();
        }
        if (!Objects.equals(previous, newValue)) {
            this.onUpdateCache.run();
        }
    }

    public void onUpdateCache(Runnable action) {
        Runnable previous = this.onUpdateCache;
        this.onUpdateCache = () -> {
            previous.run();
            action.run();
        };
    }

    public void writeToEntry() throws IllegalAccessException {
        this.entry.setValue(this.cachedValue);
    }

    public void reset() {
        this.cachedValue = this.entry.getDefault();
        this.onUpdateCache.run();
    }
}

